package gov.va.med.mhv.bluebutton.web.util;

import gov.va.med.mhv.common.api.enumeration.UserTypeEnum;
import gov.va.med.mhv.common.api.exception.MHVException;

import java.util.HashMap;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.liferay.portal.util.PortalUtil;

public class ModePhaseListener implements PhaseListener {
	private static Logger LOG = LogManager.getLogger(ModePhaseListener.class);
	
	private static final long serialVersionUID = -5701215610867004256L;

	private static final Map<String,String> FORWARDS = new HashMap<String, String>();
	
	private static final String USER_ROLE_KEY = "LIFERAY_SHARED_accountType";
	
	static {
		FORWARDS.put("healthsummary","healthsummary/healthSummary");
		FORWARDS.put("healthsummaryInfo","healthsummary/healthSummaryInfo");
		
		//ADD OTHERS HERE...
	}
	
	@Override
	public PhaseId getPhaseId() {
		return PhaseId.RESTORE_VIEW;
	}

	@Override
	public void beforePhase(PhaseEvent event) {
		// TODO Auto-generated method stub
	}

	protected UserTypeEnum getUserRoleFromSession() throws MHVException {
		UserTypeEnum userRole;
		PortletSession session = null;
		try {
			PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
			session = request.getPortletSession();
			
			String userRoleStr =  (String)session.getAttribute(USER_ROLE_KEY, PortletSession.APPLICATION_SCOPE);
			userRole = UserTypeEnum.valueOfByRole(userRoleStr);
			
		} catch(Exception e) {
			throw new MHVException("Unable to get user role from session");
		}
		return userRole;
	}
	
	public Boolean getIsPremiumUser() throws MHVException {
		return new Boolean(UserTypeEnum.isPremium(getUserRoleFromSession()));
	}
	
	@Override
	public void afterPhase(PhaseEvent event) {
		PhaseId phaseid = event.getPhaseId();
		if (phaseid == PhaseId.RESTORE_VIEW) {
			String mode = getRequestParameter("mode");
			if(LOG.isDebugEnabled()) {
				if( mode != null ) {
					LOG.debug("Mode discovered from parameter: "+mode);
				}
			}

			if (FORWARDS.containsKey(mode)) {
				try {
					if(!getIsPremiumUser()) {
						mode = "healthsummaryInfo";
					}
				} catch (MHVException e) {
					//TODO:?
				}
				FacesContext facesContext = event.getFacesContext();
				facesContext.getApplication().getNavigationHandler().handleNavigation(facesContext, null, FORWARDS.get(mode));
			}
		}
	}
	
	private String getRequestParameter(String paramKey) {
		try {
			Object o = FacesContext.getCurrentInstance().getExternalContext().getRequest();
            HttpServletRequest httpReq = null;
            if (o instanceof javax.portlet.RenderRequest) {
                    javax.portlet.RenderRequest request = (javax.portlet.RenderRequest) o;
                    httpReq = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(request));
            } else if (o instanceof javax.portlet.ResourceRequest) {
                    javax.portlet.ResourceRequest request = (javax.portlet.ResourceRequest) o;
                    httpReq = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(request));
            } else if (o instanceof javax.portlet.ActionRequest) {
                    javax.portlet.ActionRequest request = (javax.portlet.ActionRequest) o;
                    httpReq = PortalUtil.getOriginalServletRequest(PortalUtil.getHttpServletRequest(request));
            }

            return (httpReq.getParameter(paramKey));
		}
		catch(Exception e) {
			LOG.error("Unable to extract request parameter '"+paramKey+"'");
		}
		
		return "";
	}

}
